# 📘 Documentation Setup Guide

Follow these simple steps to set up and run this documentation locally on your machine.

---

## 🚀 Prerequisites

Before you begin, make sure you have the following installed:

- Node.js (version **20** or higher)

---

## 🛠️ Installation Steps

### 1. Install Node.js  
Download and install Node.js from the official website:  
👉 [https://nodejs.org/](https://nodejs.org/)  
> ⚠️ Make sure you’re using **Node.js v20.x.x or higher**

---

### 2. Open the Project in a Code Editor  
Use any modern code editor like **Visual Studio Code** to open the project folder.

---

### 3. Verify Node.js Installation  
Open your terminal and run the following command:

```bash
node -v
```

You should see a version number that starts with `20.` or higher.

---

### 4. Install Dependencies  
Navigate to the root of the project folder in the terminal and run:

```bash
npm i
```

This will install all required packages and dependencies.

---

### 5. Start the Development Server  
Once all dependencies are installed, run:

```bash
npm run start
```

This will compile and launch the documentation site locally.

---

### 6. View in Browser  
After the server starts, it will typically open automatically in your default browser.  
If it doesn’t, you can open the following link manually:

```
http://localhost:3000
```

---

## 🌐 Don't want to run locally?

You can view the live documentation here:  
👉 **[Click here to view the live docs](https://wrteam-in.github.io/eSchool-SaaS-Doc/)**
